//==============================================================================
// Project:		Wealth Transfers and their economic effects
// File name:	Box 2.3 figure b
// Objective: 	Generate the data underpinning box 2.3 figure b
//
//==============================================================================

clear all

************************
*** Data import ***
************************

cd "XXXX" //set content directory here

use combined_filtered_restricted.dta, replace

merge m:1 xwaveid wave using bequest_from_HH_death.dta //flag for inheritances due to HH deaths
drop if _merge == 2
drop _merge

xtset xwaveid wave

keep if wave == 18

************************
*** Create variables ***
************************

replace oifinha = 0 if oifinha == -10 | oifinha == -1 //inheritances
replace oifinha = . if oifinha < 0
gen bequest = oifinha
replace bequest = 0 if bequest > 0 & bequest != . & bequest_from_HH_death == 1 //filter out inheritances due to HH deaths

replace oifnptr = 0 if oifnptr == -10 //gifts
replace oifnpt = 0 if oifnpt == -10
replace oifnptr = . if oifnptr < 0
gen gift = oifnptr + oifnpt
 
gen net_worth = hwnwip - hwnwin //household net worth

gen child = 1 if hgage < 15 //generate equivalisation scale (OECD modified)
gen adult = 1 if hgage >= 15
egen total_child = total(child), by(hhrhid wave)
egen total_adult = total(adult), by(hhrhid wave)
gen equiv_scale = total_child*0.3 + total_adult*0.5 + 0.5 //0.3 for children, 1 for first adult and 0.5 for all subsequent adults

gen net_worth_e = net_worth / equiv_scale //equivalised net worth

egen total_bequest = total(bequest), by(hhrhid wave)
gen bequest_e = total_bequest/ equiv_scale //equivalised inheritances
gen bequest_e_positive = 0
replace bequest_e_positive = 1 if bequest_e > 0 & bequest_e != . //flag for an inheritance
egen total_bequest_e_positive_age = total(hhwtes) if bequest_e_positive == 1, by(hgage)
egen total_bequest_e_positive = total(hhwtes) if bequest_e_positive == 1
gen share_bequest_e_positive = total_bequest_e_positive_age * 100 / total_bequest_e_positive

egen total_gift = total(gift), by(hhrhid wave)
gen gift_e = total_gift / equiv_scale //equivalised gifts
gen gift_e_positive = 0
replace gift_e_positive = 1 if gift_e > 0 & gift_e != . //flag for a gift
egen total_gift_e_positive_age = total(hhwtes) if gift_e_positive == 1, by(hgage)
egen total_gift_e_positive = total(hhwtes) if gift_e_positive == 1
gen share_gift_e_positive = total_gift_e_positive_age * 100 / total_gift_e_positive

collapse (mean) net_worth_e (max) share_bequest_e_positive share_gift_e_positive [pweight = hhwtes], by(hgage)
replace share_bequest_e_positive = 0 if share_bequest_e_positive == .
replace share_gift_e_positive = 0 if share_gift_e_positive == .

export delimited equivalised_age_distribution.csv, replace

